package com.bytesbee.mysinglelivechannel.fragments;

import static com.bytesbee.mysinglelivechannel.utils.Constant.CLICK_DELAY_TIME;
import static com.bytesbee.mysinglelivechannel.utils.Constant.DEFAULT_UPDATE_URL;
import static com.bytesbee.mysinglelivechannel.utils.Constant.FALSE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.MARKET_URL;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.fragment.app.Fragment;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.activities.AboutUsActivity;
import com.bytesbee.mysinglelivechannel.activities.ChangePasswordActivity;
import com.bytesbee.mysinglelivechannel.activities.MainActivity;
import com.bytesbee.mysinglelivechannel.activities.PrivacyPolicyActivity;
import com.bytesbee.mysinglelivechannel.managers.DialogManager;
import com.bytesbee.mysinglelivechannel.managers.Screens;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.kongzue.dialogx.dialogs.MessageDialog;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class FragmentSettings extends Fragment implements OnClickListener {

    private SwitchCompat notificationOnOff, rtlOnOff, fullscreenOnOff;
    private LinearLayout layoutChangePassword, layoutLogout;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        @SuppressLint("InflateParams") View root_view = inflater.inflate(R.layout.fragment_settings, null);
        final LinearLayout layoutNotification = root_view.findViewById(R.id.layoutNotification);
        final LinearLayout layoutRTL = root_view.findViewById(R.id.layoutRTL);
        final LinearLayout layoutFullscreen = root_view.findViewById(R.id.layoutFullscreen);
        final LinearLayout layoutRateApp = root_view.findViewById(R.id.layoutRateApp);
        final LinearLayout layoutShare = root_view.findViewById(R.id.layoutShare);
        final LinearLayout layoutAbout = root_view.findViewById(R.id.layoutAbout);
        final LinearLayout layoutPrivacyPolicy = root_view.findViewById(R.id.layoutPrivacyPolicy);
        layoutChangePassword = root_view.findViewById(R.id.layoutChangePassword);
        layoutLogout = root_view.findViewById(R.id.layoutLogout);
        final TextView txtSettingVersion = root_view.findViewById(R.id.txtSettingVersion);
        txtSettingVersion.setText(String.format(getString(R.string.settingVersion), Utils.getAppVersionName()));

        rtlOnOff = root_view.findViewById(R.id.rtlOnOff);
        rtlOnOff.setOnClickListener(v -> restartApp());
        rtlOnOff.setOnCheckedChangeListener((compoundButton, b) -> SessionManager.get().setOnOffRTL(b));

        fullscreenOnOff = root_view.findViewById(R.id.fullscreenOnOff);
        fullscreenOnOff.setOnClickListener(v -> restartApp());
        fullscreenOnOff.setOnCheckedChangeListener((compoundButton, b) -> SessionManager.get().setOnOffFullscreen(b));

        if (Utils.isEnabledMandatoryLogin()) {
            setShowHideLayout(View.VISIBLE);
        } else {
            setShowHideLayout(View.GONE);
        }

        notificationOnOff = root_view.findViewById(R.id.notificationOnOff);
        notificationOnOff.setOnCheckedChangeListener((compoundButton, b) -> SessionManager.get().setOnOffNotification(b));

        if (SessionManager.get().isNotificationOn()) {
            notificationOnOff.setChecked(TRUE);
        } else {
            notificationOnOff.setChecked(FALSE);
        }

        if (SessionManager.get().isRTLOn()) {
            rtlOnOff.setChecked(TRUE);
        } else {
            rtlOnOff.setChecked(FALSE);
        }

        if (SessionManager.get().isFullscreenOn()) {
            fullscreenOnOff.setChecked(TRUE);
        } else {
            fullscreenOnOff.setChecked(FALSE);
        }

        layoutNotification.setOnClickListener(this);
        layoutRTL.setOnClickListener(this);
        layoutFullscreen.setOnClickListener(this);
        layoutChangePassword.setOnClickListener(this);
        layoutRateApp.setOnClickListener(this);
        layoutShare.setOnClickListener(this);
        layoutAbout.setOnClickListener(this);
        layoutPrivacyPolicy.setOnClickListener(this);
        layoutLogout.setOnClickListener(this);
        return root_view;
    }

    private void setShowHideLayout(int isShown) {
        try {
            layoutChangePassword.setVisibility(isShown);
            layoutLogout.setVisibility(isShown);
        } catch (Exception ignored) {
        }
    }

    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.layoutNotification) {
            if (notificationOnOff.isChecked()) {
                notificationOnOff.setChecked(FALSE);
            } else {
                notificationOnOff.setChecked(TRUE);
            }
        } else if (id == R.id.layoutRTL) {
            if (rtlOnOff.isChecked()) {
                rtlOnOff.setChecked(FALSE);
            } else {
                rtlOnOff.setChecked(TRUE);
            }
            restartApp();
        } else if (id == R.id.layoutFullscreen) {
            if (fullscreenOnOff.isChecked()) {
                fullscreenOnOff.setChecked(FALSE);
            } else {
                fullscreenOnOff.setChecked(TRUE);
            }
            restartApp();
        } else if (id == R.id.layoutChangePassword) {
            new Handler().postDelayed(() -> Screens.showCustomScreen(getActivity(), ChangePasswordActivity.class), CLICK_DELAY_TIME);
        } else if (id == R.id.layoutRateApp) {
            final String appName = requireActivity().getPackageName();
            try {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(MARKET_URL + appName)));
            } catch (android.content.ActivityNotFoundException anfe) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(DEFAULT_UPDATE_URL + appName)));
            }
        } else if (id == R.id.layoutShare) {
            Utils.shareApp(getActivity());
        } else if (id == R.id.layoutAbout) {
            new Handler().postDelayed(() -> Screens.showCustomScreen(getActivity(), AboutUsActivity.class), CLICK_DELAY_TIME);
        } else if (id == R.id.layoutPrivacyPolicy) {
            new Handler().postDelayed(() -> Screens.showCustomScreen(getActivity(), PrivacyPolicyActivity.class), CLICK_DELAY_TIME);
        } else if (id == R.id.layoutLogout) {
            new Handler().postDelayed(this::logout, CLICK_DELAY_TIME);
        }

    }

    private void restartApp() {
        MessageDialog.build()
                .setTitle(R.string.strRefresh)
                .setMessage(R.string.strRefreshMessage)
                .setCancelable(false)
                .setOkButton(R.string.ok, (baseDialog, v) -> {
                    Screens.showClearTopScreen(getContext(), MainActivity.class);
                    return false;
                })
                .show();
    }

    private void logout() {
        DialogManager.showYesNoDialog(getActivity(), getString(R.string.strLogout), getString(R.string.strLogoutMessage));
    }

    @Override
    public void onResume() {
        super.onResume();
    }
}
